package chess4j.moves;

import chess4j.board.Square;
import chess4j.pieces.Piece;

public class Move {

	private Square _from,_to;
	private Piece _captured,_promotion;
	
	public Move(Square from,Square to) {
		_from = from;
		_to = to;
	}
	
	public Move(Square from,Square to,Piece captured) {
		this(from,to);
		_captured = captured;
	}

	public Move(Square from,Square to,Piece captured,Piece promotion) {
		this(from,to,captured);
		_promotion = promotion;
	}
	
	public Piece captured() {
		return _captured;
	}
	
	public Square from() {
		return _from;
	}
	
	public Piece promotion() {
		return _promotion;
	}
	
	public Square to() {
		return _to;
	}
	
	@Override
	public String toString() {
		return _from.toString() + _to.toString(); 
	}
	
	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof Move)) {
			return false;
		}	
		Move mv = (Move)obj;
		if (!mv.from().equals(this.from())) return false;
		if (!mv.to().equals(this.to())) return false;
		if (mv.captured()==null) {
			if (this.captured()!=null) return false;
		} else {
			if (!mv.captured().equals(this.captured())) return false;
		}
		if (mv.promotion()==null) {
			if (this.promotion()!=null) return false;
		} else {
			if (!mv.promotion().equals(this.promotion())) return false;
		}
		return true;
	}
}
